$stitle: (3) Estimate Water Use for 2011
* --------------------------------------------------------------------*
*                                                                       *
*                 Global Trade Analysis Project                          *
*                        GTAP Water Database                             *
*                             SplitLand                                  *
*  ch #3: Estimating water withdrawal for 2011 by RB-AEZ for 140 reg     *
*                                                                       *
* --------------------------------------------------------------------*


PARAMETER
WTR0(a,b,c,r)  blue water requirement in SD (2000) [[w00:AEZ*RB*CROP*REG]];
WTR0(a,b,c,r) = WatSD(r,b,a,c);

PARAMETER
NU(a, b,c,r)     WATER REQUIREMENT PER UNIT OF CROPS IN 2000;
nu(a, b,c,r)$ prod00("irr",r,b,a,c)
         = wtr0(a,b,c,r) / prod00("irr",r,b,a,c) ;

nu(a,rb,c,r)$ (sum((b),prod00("irr",r,b,a,c)) and not prod00("irr",r,rb,a,c) )
         = sum((b), wtr0(a,b,c,r)) / sum((b), prod00("irr",r,b,a,c)) ;

nu(a,rb,c,reg)$ (sum((r,b), prod00("irr",r,b,a,c)) and not sum((b),prod00("irr",reg,b,a,c)) )
         = sum((r,b), wtr0(a,b,c,r)) / sum((r,b), prod00("irr",r,b,a,c)) ;

PARAMETER
WTR11(AEZ,RB,CROP,REG)   Irrigation Water Withdrawal in 2011 (Updated by FAO)  [[w11:AEZ*RB*CROP*REG]];
WTR11(a,b,c,r)
         = nu(a,b,c,r) * qi(a,b,c,r);


PARAMETER
WAT_LEVEL(REG,YEAR)  TARGET VALUE FOR REGINAL WATER WITHDRAWAL BASED ON FAO ;
WAT_LEVEL(REG,YEAR)$(IRWW(REG,YEAR))
         = IRWW(REG,YEAR)*1.00*1e+9;
WAT_LEVEL(REG,YEAR)$(AGWW(REG,YEAR) and not IRWW(REG,YEAR))
         = AGWW(REG,YEAR)*0.97*1e+9;
WAT_LEVEL(REG,YEAR)$(IRWR(REG,YEAR) and not AGWW(REG,YEAR) and not IRWW(REG,YEAR))
         = IRWR(REG,YEAR)*1.97*1e+9;

* note: The above scaling is based on available data on water:
*        water withdrawal to water requirement in 2000 = 1.97 average global
*        Irrigation to Ag water withdrawal in old water DB = 0.97

PARAMETER
SCALE(REG,YEAR) Scale Factor to Adjust Calculated Water Withdrawal;
SCALE(REG,'Y2011')$ (SUM((a,b,c),WTR11(a,b,c,REG))>eps)
          = WAT_LEVEL(REG,'Y2011')/SUM((A,B,C),WTR11(a,b,c,REG));
SCALE(REG,'Y2011')$ (SUM((a,b,c),WTR11(a,b,c,REG)) le eps or not WAT_LEVEL(REG,'Y2011'))
          = SUM(R, WAT_LEVEL(R,'Y2011'))/SUM((A,B,C,R),WTR11(a,b,c,R));

*--->>> UPDATE <<<--- *
*--->>> wtr11 by applying scale
wtr11(a,b,c,r) = scale(r,'Y2011') * wtr11(a,b,c,r);
